//***********************************************************************
//***********************************************************************
//****																*****
//****	Routinen zur Ansteuerung des Absolutwegsensors 				*****
//****	mit RS485 Schnittstelle										*****
//****	copyrigth (c) 2010 by Dipl. Ing. Steffen Taubmann			*****
//****																*****
//****	Kontakt: steffenta@gmx.de									*****
//****																*****
//***********************************************************************
//***********************************************************************


//  ********************************************************************
//	****														
//	****   Antwort von Sensor empfangen
//	****   bergabe: Anzahl: Anzahl erwarteter Bytes
//	****             Time:   maximale Zeit bis Antwort in ms
//	****             Daten ab EBuff im RAM
//	****   Rckgabe: 0  --> alles OK
//	****   			-1 --> Error
//	****
//  ********************************************************************

signed int getSensorData(int Anzahl, int16 Time)
{ int x;
  int BCC=0;
  signed int result=-1;

  while(TXIE | !TRMT){restart_WDT();} 						// warten bis senden beendet undSendepuffer leer
  RS485_TXEN=0;												// Treiber auf Empfang

  AbsTimeOutTimer=0;
  while ((!_EmpfangAktiv)&&(AbsTimeOutTimer<Time)) 			// waretn, bis Antwort oder Timeout
   restart_wdt();
 
  while (_EmpfangAktiv) restart_wdt();						// warten, bis Datensatz komplett empfangen oder Timeout
  if (_DatenEmpfangen)										// gltiger Datensatz empfangen?
  { if((PEBuff+1)==Anzahl)									// Anzahl empfangener Bytes OK?
	{ for (x=0; x<Anzahl-1; ++x) 							// Checksumme testen
	  { BCC^=EBuff[x];
		if (BCC==EBuff[Anzahl-1])
		  result=0;											// Daten OK
	  }

	} //if(PEBuff+1==Anzahl)
  } //if (DatenEmpfangen)
  _DatenEmpfangen=False;
  PEBuff=0;													// wieder auf Anfang setzen
return(result);
}

//  ********************************************************************
//	****														
//	****   MMSSSystemTest - testet Kommunikation mit Sensor
//	****   Adresse Adr
//	****   Rckgabe=0, wenn OK
//	****										
//  ********************************************************************

signed int MMS_SystemTest(int Adr)
{ SBuff[0]=0x3;
  SBuff[1]=Adr;
  SBuff[2]=0xF0;
  SendRSData(3);
  if (getSensorData(4,20)==0) 
   return(0);
  else
   return(-1);
}

//  ***************************************************************************
//	****														
//	****   MMSS_SetSysAdr setzt die Adresse des Sensors auf Adr  
//	****   !!! darf nur verwendet werden, wenn nur ein Sensor angeschlossen.
//	****   Rckgabe=0, wenn OK
//	****
//  ***************************************************************************

signed int MMS_SetSysAdr(int Adr)
{ SBuff[0]=0x6;
  SBuff[1]=0xFF;
  SBuff[2]='A';
  SBuff[3]=adr;
  SBuff[4]='A';
  SBuff[5]=adr;
  SendRSData(6);
  if (getSensorData(4,20)==0) 
   return(0);
  else
   return(-1);
}

//  ***************************************************************************
//	****														
//	****   MMSS_REsetSytem setzt den Sensor mit Adresse Adr zurck 
//	****   und den Absolutwert des Sensors auf 0
//	****   Rckgabe=0, wenn OK
//	****
//  ***************************************************************************

signed int MMS_ResetSystem(int Adr)
{ SBuff[0]=0x03;
  SBuff[1]=Adr;
  SBuff[2]='R';
  SendRSData(3);
  if (getSensorData(4,20)==0) 
   return(0);
  else
   return(-1);
}

//  ***************************************************************************
//	****														
//	****   MMSS_GetABSPosition liest die Absolutwertposition des Sensors
//	****   Rckgabe: Pos   --> int32 Absolutwertpositiion des Sensors
//	****   			Flags --> Flags des Sensors (Feldstrke etc.)
//	****   Rckgabe=0, wenn OK
//	****
//  ***************************************************************************

signed int MMS_GetABSPosition(int Adr,signed int32 *Pos, int *Flags)
{ int32 temp;
  signed int result=-1;

  SBuff[0]=0x03;
  SBuff[1]=Adr;
  SBuff[2]='P';
  SendRSData(3);
  if (getSensorData(8,20)==0) 
  { result=0;
	Temp=Ebuff[2]; Temp*=0x1000000; *Pos=Temp;
	Temp=Ebuff[3]; Temp*=0x10000; *Pos+=Temp;
	Temp=Ebuff[4]; Temp*=0x100; *Pos+=Temp;
	*Pos+=Ebuff[5];
 	*Flags=Ebuff[6];
  }
  return(result);
}

//  ***************************************************************************************
//	****														
//	****   MMSS_GetPosition liest die Position des Sensors in Bezug auf den Magnetstreifen
//	****   Rckgabe: Pos   --> int16 Positiion des Sensors
//	****   			Flags --> Flags des Sensors (Feldstrke etc.)
//	****   Rckgabe=0, wenn OK
//  ***************************************************************************************

signed int MMS_GetPosition(int Adr, int16 *Pos, int *Flags)
{ int16 temp;
  signed int result=-1;

 SBuff[0]=0x03;
 SBuff[1]=Adr;
 SBuff[2]='p';
 SendRSData(3);
 if (getSensorData(6,20)==0) 
 { result=0;
   Temp=Ebuff[2]; Temp*=0x100; *Pos=Temp;
   Temp=Ebuff[3]; *Pos+=Temp;
   *Flags=Ebuff[4];
 }
 return(result);
}

//  ******************************************************************************************
//	****														
//	****   MMSS_GetMagnitude liest die aktuelle Feldstrke (Magnitude) des Sensors 
//	****   Rckgabe: Mag   --> int16 Magnitude
//	****   			 Flags --> Flags des Sensors (Feldstrke etc.)
//	****   Rckgabe=0, wenn OK
//	****
//  ******************************************************************************************

signed int MMS_GetMagnitude(int Adr, int16 *Mag, int *Flags)
{ int temp;
  signed int result=-1;

  SBuff[0]=0x03;
  SBuff[1]=Adr;
  SBuff[2]='m';
  SendRSData(3);
  if (getSensorData(6,20)==0) 
  { result=0;
    Temp=Ebuff[2]; Temp*=0x100; *Mag=Temp;
    Temp=Ebuff[3]; *Mag+=Temp;
    *Flags=Ebuff[4];
  }
  return(result);
}

